/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.core;

import dev.compactmods.crafting.api.recipe.layers.RecipeLayerType;
import dev.compactmods.crafting.recipes.components.ComponentRegistration;
import dev.compactmods.crafting.recipes.layers.FilledComponentRecipeLayer;
import dev.compactmods.crafting.recipes.layers.HollowComponentRecipeLayer;
import dev.compactmods.crafting.recipes.layers.MixedComponentRecipeLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="compactcrafting", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CCLayerTypes {
    public static final ResourceLocation REC_LAYERS = new ResourceLocation("compactcrafting", "recipe_layers");
    public static DeferredRegister<RecipeLayerType<?>> RECIPE_LAYERS = DeferredRegister.create((ResourceLocation)REC_LAYERS, (String)"compactcrafting");
    public static IForgeRegistry<RecipeLayerType<?>> RECIPE_LAYER_TYPES;
    public static final RegistryObject<RecipeLayerType<FilledComponentRecipeLayer>> FILLED_LAYER_SERIALIZER;
    public static final RegistryObject<RecipeLayerType<HollowComponentRecipeLayer>> HOLLOW_LAYER_TYPE;
    public static final RegistryObject<RecipeLayerType<MixedComponentRecipeLayer>> MIXED_LAYER_TYPE;

    public static void init(IEventBus eventBus) {
        RECIPE_LAYERS.register(eventBus);
    }

    @SubscribeEvent
    public static void newRegistries(NewRegistryEvent evt) {
        RegistryBuilder b = new RegistryBuilder().setName(REC_LAYERS).setType(ComponentRegistration.c(RecipeLayerType.class));
        evt.create(b);
    }

    @SubscribeEvent
    public static void layerRegistration(RegistryEvent.Register<RecipeLayerType<?>> evt) {
        RECIPE_LAYER_TYPES = evt.getRegistry();
    }

    static {
        FILLED_LAYER_SERIALIZER = RECIPE_LAYERS.register("filled", FilledComponentRecipeLayer::new);
        HOLLOW_LAYER_TYPE = RECIPE_LAYERS.register("hollow", HollowComponentRecipeLayer::new);
        MIXED_LAYER_TYPE = RECIPE_LAYERS.register("mixed", MixedComponentRecipeLayer::new);
    }
}

